/*
 * Decompiled with CFR 0.152.
 */
package forge.net.nimajnebec.autoelytra.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import forge.net.nimajnebec.autoelytra.AutoElytra;
import forge.net.nimajnebec.autoelytra.config.ClothConfigFactory;
import forge.net.nimajnebec.autoelytra.config.ConfigOption;
import forge.net.nimajnebec.autoelytra.config.forge.ConfigurationImpl;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;

public class Configuration {
    private static final List<ConfigOption<Object>> options = new ArrayList<ConfigOption<Object>>();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static final ConfigOption<Boolean> AUTO_EQUIP_ENABLED = Configuration.registerOption(new ConfigOption<Boolean>("auto_equip_enabled", true));

    public static void load() {
        AutoElytra.logger.info("Loading Auto Elytra config...");
        try {
            String data = Files.readString(Configuration.getConfigFile());
            Map map = (Map)gson.fromJson(data, Map.class);
            for (ConfigOption<Object> option : options) {
                option.set(map.get(option.getName()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void save() {
        AutoElytra.logger.info("Saving Auto Elytra config...");
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ConfigOption<Object> option : options) {
            map.put(option.getName(), option.get());
        }
        try {
            Files.writeString(Configuration.getConfigFile(), (CharSequence)gson.toJson(map), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Screen createScreen(Screen parent) {
        if (!Configuration.ClothConfigInstalled()) {
            return null;
        }
        return ClothConfigFactory.create(parent);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean ClothConfigInstalled() {
        return ConfigurationImpl.ClothConfigInstalled();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigDirectory() {
        return ConfigurationImpl.getConfigDirectory();
    }

    public static Path getConfigFile() {
        return Configuration.getConfigDirectory().resolve("autoelytra.json");
    }

    private static <T> ConfigOption<T> registerOption(ConfigOption<T> option) {
        options.add(option);
        return option;
    }
}

